/*
 * Copyright (c) 2017 - 2018 , NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */


#include "lcd.h"
#include "fsl_gpio.h"
#include "fsl_spi.h"

#define GPIO_LCD_CS_PORT_IDX     0u
#define GPIO_LCD_CS_PIN_IDX      17u

#define GPIO_LCD_BL_PORT_IDX     0u
#define GPIO_LCD_BL_PIN_IDX      18u

#define GPIO_LCD_DC_PORT_IDX     0u
#define GPIO_LCD_DC_PIN_IDX      19u


#define GPIO_SPI_CLK_PORT_IDX     0u
#define GPIO_SPI_CLK_PIN_IDX      21u

#define GPIO_SPI_TX_PORT_IDX      0u
#define GPIO_SPI_TX_PIN_IDX       22u


#define EXAMPLE_SPI_MASTER SPI0


void __LCD_delay_ms(uint32_t);
void __LCD_HW_INIT(void)
{
	

    gpio_pin_config_t   gpioPinConfig;
    // Select the function clock source for the master, SPI0 (slave will be clocked by the master's SCK)
    SYSCON->FCLKSEL[9] = 1;  
    SYSCON->SYSAHBCLKCTRL0 |= (1<<11);
    SYSCON->PRESETCTRL0 &= ~(1<<11);
    SYSCON->PRESETCTRL0 |= (1<<11);	
    EXAMPLE_SPI_MASTER->DIV = 0;
    EXAMPLE_SPI_MASTER->CFG = SPI_CFG_ENABLE_MASK | SPI_CFG_MASTER_MASK |SPI_CFG_CPOL_MASK | SPI_CFG_CPHA_MASK  ;
    EXAMPLE_SPI_MASTER->DLY = 0;
    EXAMPLE_SPI_MASTER->TXCTL = SPI_TXCTL_EOT_MASK | SPI_TXCTL_LEN(7);

     /* GPIO Pins. */
    CLOCK_EnableClock(kCLOCK_Gpio0);
    CLOCK_EnableClock(kCLOCK_Gpio1);

    gpioPinConfig.pinDirection = kGPIO_DigitalOutput;
    gpioPinConfig.outputLogic  = 1u; /* output high as default. */

    GPIO_PinInit(GPIO, GPIO_LCD_CS_PORT_IDX, GPIO_LCD_CS_PIN_IDX, &gpioPinConfig);
    GPIO_PinInit(GPIO, GPIO_LCD_BL_PORT_IDX, GPIO_LCD_BL_PIN_IDX, &gpioPinConfig);
    GPIO_PinInit(GPIO, GPIO_LCD_DC_PORT_IDX, GPIO_LCD_DC_PIN_IDX, &gpioPinConfig);

}

void __LCD_BKL_SET(void)
{
    GPIO_PinWrite(GPIO, GPIO_LCD_BL_PORT_IDX, GPIO_LCD_BL_PIN_IDX, 1u);
}

void __LCD_CS_CLR(void)
{

	GPIO->B[GPIO_LCD_CS_PORT_IDX][GPIO_LCD_CS_PIN_IDX] = 0;
}

void __LCD_CS_SET(void)
{

	GPIO->B[GPIO_LCD_CS_PORT_IDX][GPIO_LCD_CS_PIN_IDX] = 1;

}

void __LCD_DC_CLR(void)
{
    GPIO_PinWrite(GPIO, GPIO_LCD_DC_PORT_IDX, GPIO_LCD_DC_PIN_IDX, 0u);
}

void __LCD_DC_SET(void)
{
    GPIO_PinWrite(GPIO, GPIO_LCD_DC_PORT_IDX, GPIO_LCD_DC_PIN_IDX, 1u);
}


void __LCD_WRITE_nBYTE(uint8_t txDat,uint32_t n ){
    int32_t i ;

    for(i = 0;i<=n; i++){	
    	EXAMPLE_SPI_MASTER->TXCTL &= ~(SPI_TXCTL_EOF_MASK);                 // Start a new transfer, clear the EOT bit
    	while ((EXAMPLE_SPI_MASTER->STAT & SPI_STAT_TXRDY_MASK) == 0U)
    	{
    	}
    	EXAMPLE_SPI_MASTER->TXCTL |= SPI_TXCTL_EOF_MASK | SPI_TXCTL_RXIGNORE_MASK ;
    	EXAMPLE_SPI_MASTER->TXDAT = txDat;
    }

    while ((EXAMPLE_SPI_MASTER->STAT & SPI_STAT_MSTIDLE_MASK) == 0U)
    {
    }		
}


void __LCD_WRITE_BYTE(uint8_t txDat)
{

 
 	EXAMPLE_SPI_MASTER->TXCTL &= ~(SPI_TXCTL_EOF_MASK);                 // Start a new transfer, clear the EOT bit

	while ((EXAMPLE_SPI_MASTER->STAT & SPI_STAT_TXRDY_MASK) == 0U)
	{
	}
	
	EXAMPLE_SPI_MASTER->TXCTL |= SPI_TXCTL_EOF_MASK | SPI_TXCTL_RXIGNORE_MASK ;

	EXAMPLE_SPI_MASTER->TXDAT = txDat;
	
	while ((EXAMPLE_SPI_MASTER->STAT & SPI_STAT_MSTIDLE_MASK) == 0U)
	{
	}

}

volatile uint32_t vu32DelayCount;

void __LCD_delay_ms(uint32_t dlyMs)
{
    for (vu32DelayCount = 0u; vu32DelayCount < 150 * dlyMs; vu32DelayCount++)
    {
        __NOP();
    }
}

void lcd_fill_screen_dma(uint16_t hwXpos, uint16_t hwYpos, uint8_t *datBuf)
{

}


